/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Hashtable;

public class Meter
extends Panel {
    private double value;
    private double valuemax;
    private double valuemin;
    private Graphics gimage;
    private Image image;
    private Image image0;
    private Dimension dimage;
    private Hashtable meterScale;
    private String label = "";
    private int ifont = -1;
    private Font f1;
    private Font f2;

    public Meter(double d, double d2) {
        this.valuemax = d2;
        this.valuemin = d;
        this.value = d;
    }

    public Meter() {
        this(0.0, 100.0);
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Dimension dimension = this.size();
        int n6 = Math.min(dimension.width, dimension.height);
        if (this.ifont == -1 || this.ifont != 12 * n6 / 190) {
            this.ifont = 12 * n6 / 190;
            this.f1 = new Font("Helvetica", 1, this.ifont);
            this.f2 = new Font("Helvetica", 0, this.ifont * 3 / 4);
        }
        if (this.gimage == null || dimension.width != this.dimage.width || dimension.height != this.dimage.height) {
            this.dimage = dimension;
            this.image = this.createImage(this.dimage.width, this.dimage.height);
            this.image0 = this.createImage(this.dimage.width, this.dimage.height);
            this.gimage = this.image.getGraphics();
            Graphics graphics2 = this.image0.getGraphics();
            graphics2.setColor(this.getBackground());
            graphics2.fillRect(0, 0, dimension.width, dimension.height);
            graphics2.setColor(new Color(80, 20, 20));
            int n7 = dimension.width / 16;
            n5 = dimension.height / 16;
            n4 = dimension.width / 8;
            n3 = dimension.height / 8;
            graphics2.fillRoundRect(n7, n5, dimension.width * 7 / 8, dimension.height * 7 / 8, n4, n3);
            n2 = dimension.width / 8;
            n = dimension.height / 8;
            graphics2.setColor(Color.lightGray);
            graphics2.fillRoundRect(n2, n, dimension.width * 3 / 4, dimension.height * 15 / 32, n4, n3);
            double d = 0.16;
            n7 = (int)Math.round((double)dimension.width * d);
            n2 = (int)Math.round((double)dimension.width * (1.0 - d));
            n5 = (int)Math.round((double)dimension.height * 0.26);
            graphics2.setColor(Color.black);
            graphics2.drawLine(n7, n5, n2, n5);
            graphics2.setFont(this.f1);
            FontMetrics fontMetrics = graphics2.getFontMetrics();
            graphics2.setColor(Color.black);
            graphics2.drawString(this.label, dimension.width / 2 - fontMetrics.stringWidth(this.label) / 2, dimension.height / 2);
            graphics2.setFont(this.f2);
            fontMetrics = graphics2.getFontMetrics();
            int n8 = fontMetrics.getMaxAscent();
            Enumeration enumeration = this.meterScale.keys();
            double d2 = (double)dimension.width * (0.5 - d);
            double d3 = d2 / Math.tan(0.6108652381980153);
            while (enumeration.hasMoreElements()) {
                Double d4 = (Double)enumeration.nextElement();
                String string = (String)this.meterScale.get(d4);
                double d5 = d4;
                double d6 = 70.0 * (d5 - this.valuemin) / (this.valuemax - this.valuemin) - 35.0;
                double d7 = Math.tan(Math.PI * d6 / 180.0);
                double d8 = (double)(dimension.width / 2) + d3 * d7;
                int n9 = (int)Math.round(d8);
                d8 = (double)(dimension.width / 2) + (d3 - (double)dimension.height * 0.05) * d7;
                int n10 = (int)Math.round(d8);
                graphics2.drawLine(n9, n5, n10, n5 + dimension.height / 20);
                graphics2.drawString(string, n10 - fontMetrics.stringWidth(string) / 2, n5 + dimension.height / 20 + n8);
            }
        }
        this.gimage.drawImage(this.image0, 0, 0, null);
        double d = 70.0 * (this.value - this.valuemin) / (this.valuemax - this.valuemin) - 35.0;
        n5 = dimension.width / 2;
        n4 = dimension.height * 3 / 4;
        n3 = (int)(Math.sin(d *= Math.PI / 180) * (double)dimension.width * 0.6) + n5;
        n2 = (int)(-Math.cos(d) * (double)dimension.height * 0.6) + n4;
        n = dimension.height * 15 / 32 + dimension.height / 8;
        int n11 = n5 + (n - n4) * (n3 - n5) / (n2 - n4);
        this.gimage.setColor(Color.black);
        this.gimage.drawLine(n11, n, n3, n2);
        graphics.drawImage(this.image, 0, 0, null);
    }

    public void setValue(double d) {
        this.value = Math.min(this.valuemax, Math.max(d, this.valuemin));
    }

    public void setScale(Hashtable hashtable) {
        this.meterScale = hashtable;
    }

    public void setLabel(String string) {
        this.label = string;
    }
}

